//
// Created by Filip on 06/12/2025.
//
#include <iostream>
#include <vector>
using namespace std;

enum Direction
{
    PositiveX = 0b01,
    NegativeX = 0b11,
    PositiveY = 0b00,
    NegativeY = 0b10,

    AxisMask = 0b01,
    SignMask = 0b10,

    X_Val = 1,
    Y_Val = 0,
    Pos_val = 0,
    Neg_val = 0b10
};

struct Point
{
    int x;
    int y;
};

#define ON_A(d,A) ((d & AxisMask) == A##_Val)

bool DoIntersection(const Point& p1, const Point& p2, Direction d1, Direction d2);
bool AreParallel(Direction d1, Direction d2);
void FindIntersection(const Point& p1, const Point& p2, Direction d1, Direction d2, Point* p);
bool IsPointOnLine(const Point& p1, Direction d, const Point& to_check);
int TimeToReach(const Point& p1, Direction d, const Point& to_check);

vector<Point> points;

const Direction all_dirs[4] = {PositiveX, NegativeX, PositiveY, NegativeY};
int main()
{
    int n;
    cin >> n;

    int total = 0;
    points = vector<Point>(n);
    for(int i = 0; i < n; i++)
    {
        cin >> points[i].x;
        cin >> points[i].y;
    }

    for(int i = 0; i < n; i++)
    {
        for (auto dir1 : all_dirs)
        {
            for(int j = 0; j < n; j++)
            {
                if (i == j)
                    continue;
                for (auto dir2 : all_dirs)
                {
                  //  if ((dir1 & AxisMask) != (dir2 & AxisMask))
                       // continue;
                    if (DoIntersection(points[i], points[j], dir1, dir2))
                        total++;
                }
            }
        }
    }

    cout << (total / 2) << endl;
}

bool DoIntersection(const Point& p1, const Point& p2, Direction d1, Direction d2)
{
    if (AreParallel(d1, d2))
        return false;

    Point intersection{};
    FindIntersection(p1, p2, d1, d2, &intersection);
    bool will_intersect = IsPointOnLine(p1, d1, intersection) && IsPointOnLine(p2, d2, intersection);
    if (!will_intersect)
        return false;

    int t1 = TimeToReach(p1, d1, intersection);
    int t2 = TimeToReach(p2, d2, intersection);
    return t1 == t2;
}

int TimeToReach(const Point& p1, Direction d, const Point& to_check)
{
    if (ON_A(d, X))
        return abs(p1.x - to_check.x);
    if (ON_A(d, Y))
        return abs(p1.y - to_check.y);
}

void FindIntersection(const Point& p1, const Point& p2, Direction d1, Direction d2, Point* p)
{
    int x = (d1 & AxisMask) == X_Val ? p1.x : p2.x;
    int y = (d1 & AxisMask) == Y_Val ? p1.y : p2.y;
    p->x = y;
    p->y = x;
}

bool IsPointOnLine(const Point& p1, Direction d, const Point& to_check)
{
    if (ON_A(d, X))
    {
        if (p1.y != to_check.y)
            return false;

        if (d == NegativeX)
            return to_check.x <= p1.x;
        if (d == PositiveX)
            return to_check.x >= p1.x;
    }

    if (ON_A(d, Y))
    {
        if (p1.x != to_check.x)
            return false;

        if (d == NegativeY)
            return to_check.y <= p1.y;
        if (d == PositiveY)
            return to_check.y >= p1.y;
    }
    return false;
}

bool AreParallel(const Direction d1, const Direction d2)
{
    if ((d1 == NegativeX || d1 == PositiveX) && (d2 == NegativeX || d2 == PositiveX))
        return true;
    if ((d1 == NegativeY || d1 == PositiveY) && (d2 == NegativeY || d2 == PositiveY))
        return true;

    return false;
}